/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.reflect.BattleTowersReflect;
import com.charles445.rltweaker.util.AIUtil;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import com.charles445.rltweaker.util.WorldGeneratorWrapper;
import com.google.common.base.Function;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class BattleTowersHandler {
    public long tickedTime;
    BattleTowersReflect reflector;
    public int cachedTowerDestroyerConfig;

    public BattleTowersHandler() {
        block4: {
            try {
                this.reflector = new BattleTowersReflect();
                if (ModConfig.server.battletowers.dimensionBlacklistEnabled || ModConfig.server.battletowers.consistentTowerGeneration) {
                    CompatUtil.wrapSpecificHandler("BTWorldLoadEvent", x$0 -> new BTWorldLoadEvent((IEventListener)x$0), "atomicstryker.battletowers.common.WorldGenHandler", "eventWorldLoad");
                    CompatUtil.findAndRemoveHandlerFromEventBus("atomicstryker.battletowers.common.WorldGenHandler", "eventWorldLoad");
                }
                if (ModConfig.server.battletowers.consistentTowerGeneration) {
                    CompatUtil.wrapSpecificHandler("BTWorldSaveEvent", x$0 -> new BTWorldSaveEvent((IEventListener)x$0), "atomicstryker.battletowers.common.WorldGenHandler", "eventWorldSave");
                    CompatUtil.findAndRemoveHandlerFromEventBus("atomicstryker.battletowers.common.WorldGenHandler", "eventWorldSave");
                    BTWorldGenerator generator = new BTWorldGenerator();
                    generator = CompatUtil.tryWrapWorldGenerator(generator, this.reflector.c_WorldGenHandler);
                }
                this.cachedTowerDestroyerConfig = this.reflector.getTowerDestroyerEnabled();
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup BattleTowersHandler!", (Throwable)e);
                ErrorUtil.logSilent("BattleTowers Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (ModConfig.server.battletowers.golemHighAggression && this.reflector.isEntityGolem(event.getEntity())) {
            EntityCreature golem = (EntityCreature)event.getEntity();
            AIUtil.tryAndReplaceAllTasks((EntityLiving)golem, golem.field_70715_bh, EntityAIHurtByTarget.class, (Function<EntityAITasks.EntityAITaskEntry, EntityAIBase>)((Function)oldTask -> new GolemHurtByTarget(golem, false, new Class[0])));
        }
        if (this.reflector.isLycanitesAvailable() && ModConfig.server.battletowers.golemLycanitesProjectile && this.reflector.isEntityGolemFireball(event.getEntity())) {
            try {
                Entity fireball = event.getEntity();
                EntityLiving shooter = (EntityLiving)this.reflector.f_AS_EntityGolemFireball_shooterEntity.get(fireball);
                Entity demonFireball = this.reflector.createLycanitesProjectileWithNameAndShooter(ModConfig.server.battletowers.golemLycanitesProjectileName, (Entity)shooter, (float)ModConfig.server.battletowers.golemLycanitesProjectileScaleModifier);
                if (demonFireball == null) {
                    return;
                }
                demonFireball.func_70107_b(fireball.field_70165_t, fireball.field_70163_u, fireball.field_70161_v);
                demonFireball.field_70159_w = this.reflector.getGolemFireballAccelerationX(fireball);
                demonFireball.field_70181_x = this.reflector.getGolemFireballAccelerationY(fireball);
                demonFireball.field_70179_y = this.reflector.getGolemFireballAccelerationZ(fireball);
                demonFireball.field_70177_z = fireball.field_70177_z;
                demonFireball.field_70125_A = fireball.field_70125_A;
                demonFireball.field_70126_B = fireball.field_70126_B;
                demonFireball.field_70127_C = fireball.field_70127_C;
                double speedModifier = ModConfig.server.battletowers.golemLycanitesProjectileSpeedModifier;
                demonFireball.field_70159_w *= speedModifier;
                demonFireball.field_70181_x *= speedModifier;
                demonFireball.field_70179_y *= speedModifier;
                shooter.func_130014_f_().func_72838_d(demonFireball);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                ErrorUtil.logSilent("BT golemLycanitesProjectile Invocation");
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        boolean suffocationFix = ModConfig.server.battletowers.golemSuffocatingFix;
        boolean fallingBlockFix = ModConfig.server.battletowers.golemFallingBlockFix;
        boolean anvilFix = ModConfig.server.battletowers.golemAnvilFix;
        boolean lycanitesFluidFix = ModConfig.server.battletowers.golemLycanitesFluidFix;
        if (!(suffocationFix || fallingBlockFix || anvilFix || lycanitesFluidFix)) {
            return;
        }
        String damageType = event.getSource().func_76355_l();
        if (suffocationFix && damageType.equals("inWall") && this.reflector.isEntityGolem((Entity)event.getEntityLiving())) {
            event.setCanceled(true);
            return;
        }
        if (fallingBlockFix && damageType.equals("fallingBlock") && this.reflector.isEntityGolem((Entity)event.getEntityLiving())) {
            event.setCanceled(true);
            return;
        }
        if (anvilFix && damageType.equals("anvil") && this.reflector.isEntityGolem((Entity)event.getEntityLiving())) {
            event.setCanceled(true);
            return;
        }
        if (lycanitesFluidFix && (damageType.equals("acid") || damageType.equals("ooze")) && this.reflector.isEntityGolem((Entity)event.getEntityLiving())) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        boolean dormantSpeedFix = ModConfig.server.battletowers.golemDormantSpeedFix;
        boolean drownFix = ModConfig.server.battletowers.golemDrowningFix;
        double golemSpeedCap = ModConfig.server.battletowers.golemSpeedCap;
        double golemSpeedCapUpwards = ModConfig.server.battletowers.golemSpeedCapUpwards;
        boolean dismountFix = ModConfig.server.battletowers.golemAutoDismount;
        if (!dormantSpeedFix && !drownFix && !dismountFix && golemSpeedCap < 0.0 && golemSpeedCapUpwards < 0.0) {
            return;
        }
        if (this.reflector.isEntityGolem((Entity)event.getEntityLiving())) {
            EntityLivingBase golem = event.getEntityLiving();
            if (dismountFix) {
                golem.func_184210_p();
            }
            if (drownFix) {
                golem.func_70050_g(300);
            }
            if (golemSpeedCap >= 0.0) {
                if (golem.field_70159_w > golemSpeedCap) {
                    golem.field_70159_w = golemSpeedCap;
                } else if (golem.field_70159_w < -golemSpeedCap) {
                    golem.field_70159_w = -golemSpeedCap;
                }
                if (golem.field_70179_y > golemSpeedCap) {
                    golem.field_70179_y = golemSpeedCap;
                } else if (golem.field_70179_y < -golemSpeedCap) {
                    golem.field_70179_y = -golemSpeedCap;
                }
            }
            if (golemSpeedCapUpwards >= 0.0 && golem.field_70181_x > golemSpeedCapUpwards) {
                golem.field_70181_x = golemSpeedCapUpwards;
            }
            if (dormantSpeedFix) {
                try {
                    if (this.reflector.getIsDormant(golem)) {
                        golem.field_70159_w = 0.0;
                        golem.field_70181_x = 0.0;
                        golem.field_70179_y = 0.0;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    ErrorUtil.logSilent("BT getIsDormant Invocation");
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onTick(TickEvent.WorldTickEvent tick) {
        if (tick.phase == TickEvent.Phase.START && ModConfig.server.battletowers.enforceTowerDestructionConfig) {
            try {
                if (this.reflector.getTowerDestroyerEnabled() != this.cachedTowerDestroyerConfig) {
                    RLTweaker.logger.info("Fixing Tower Destroyer Config");
                    this.reflector.setTowerDestroyerEnabled(this.cachedTowerDestroyerConfig);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                ErrorUtil.logSilent("BT enforceTowerDestructionConfig Invocation");
            }
        }
        if (ModConfig.server.battletowers.towerExplosionNoCredit && System.currentTimeMillis() > this.tickedTime) {
            this.tickedTime = System.currentTimeMillis() + 14000L;
            try {
                Set<Object> towerDestroyers = this.reflector.getTowerDestroyers();
                if (towerDestroyers != null && towerDestroyers.size() > 0) {
                    for (Object destroyer : towerDestroyers) {
                        if (destroyer == null) continue;
                        this.reflector.setDestroyerPlayer(destroyer, null);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                ErrorUtil.logSilent("BT getTowerDestroyers Invocation");
            }
        }
    }

    @SubscribeEvent
    public void onApplyPotion(PotionEvent.PotionApplicableEvent event) {
        if (ModConfig.server.battletowers.golemLycanitesFluidFix && this.reflector.isEntityGolem((Entity)event.getEntityLiving())) {
            PotionEffect effect = event.getPotionEffect();
            if (effect == null) {
                return;
            }
            String effectName = effect.func_76453_d();
            if (effectName.equals("effect.plague")) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld() != null && ModConfig.server.battletowers.removeUnloadedTowerDestroyers) {
            try {
                Set<Object> towerDestroyers = this.reflector.getTowerDestroyers();
                if (towerDestroyers != null && towerDestroyers.size() > 0) {
                    for (Object destroyer : towerDestroyers) {
                        if (destroyer == null || this.reflector.getDestroyerDeleteMe(destroyer)) continue;
                        RLTweaker.logger.info("Removing tower destroyer for unloaded world");
                        this.reflector.setDestroyerDeleteMe(destroyer, true);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                ErrorUtil.logSilent("BT removeUnloadedTowerDestroyers Invocation");
            }
        }
    }

    public boolean isDimensionWhitelisted(World world) {
        if (!ModConfig.server.battletowers.dimensionBlacklistEnabled) {
            return true;
        }
        int dimension = world.field_73011_w.getDimension();
        int[] blackListIds = ModConfig.server.battletowers.dimensionBlacklistIds;
        boolean blacklistHasDimension = false;
        for (int i = 0; i < blackListIds.length; ++i) {
            if (blackListIds[i] != dimension) continue;
            blacklistHasDimension = true;
            break;
        }
        return blacklistHasDimension == ModConfig.server.battletowers.dimensionBlacklistIsWhitelist;
    }

    public class BTWorldGenerator
    extends WorldGeneratorWrapper {
        private int setup = -1;
        private Object worldGenHandler = null;
        private int minDistanceFromSpawn;
        private int minDistanceBetweenTowers;
        private double minDistanceBetweenTowersArea;

        @Override
        public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
            int alignment = 2;
            if (chunkX % alignment != 0) {
                return;
            }
            if (chunkZ % alignment != 0) {
                return;
            }
            if (this.setup == -1) {
                try {
                    this.worldGenHandler = BattleTowersHandler.this.reflector.c_WorldGenHandler.cast(this.getWrappedGenerator());
                    this.minDistanceFromSpawn = BattleTowersHandler.this.reflector.getMinDistanceFromSpawn();
                    this.minDistanceBetweenTowers = BattleTowersHandler.this.reflector.getMinDistanceBetweenTowers();
                    this.minDistanceBetweenTowersArea = Math.PI * (double)this.minDistanceBetweenTowers * (double)this.minDistanceBetweenTowers / 1024.0;
                    this.minDistanceBetweenTowersArea /= (double)alignment;
                    this.minDistanceBetweenTowersArea /= (double)alignment;
                    if (this.minDistanceBetweenTowersArea < 1.0) {
                        this.minDistanceBetweenTowersArea = 1.0;
                    }
                    this.setup = 1;
                }
                catch (ClassCastException | IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                    this.setup = 0;
                }
            }
            if (this.setup == 0) {
                this.generateWrapped(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                return;
            }
            if (!BattleTowersHandler.this.isDimensionWhitelisted(world)) {
                return;
            }
            try {
                int blockX = chunkX * 16;
                int blockZ = chunkZ * 16;
                BlockPos blockPos = new BlockPos(blockX, 0, blockZ);
                Biome biome = world.func_180494_b(blockPos.func_177982_a(16, 0, 16));
                BlockPos middlePos = blockPos.func_177982_a(8, 0, 8);
                if (biome != Biome.func_150568_d((int)8) && BattleTowersHandler.this.reflector.getIsBiomeAllowed(this.worldGenHandler, biome) && BattleTowersHandler.this.reflector.getIsChunkProviderAllowed(this.worldGenHandler, chunkProvider)) {
                    int zz;
                    BlockPos spawn = world.func_175694_M();
                    int xx = spawn.func_177958_n() - middlePos.func_177958_n();
                    if (Math.sqrt(xx * xx + (zz = spawn.func_177952_p() - middlePos.func_177952_p()) * zz) < (double)this.minDistanceFromSpawn) {
                        return;
                    }
                    random.setSeed((random.nextLong() * 4455743L + 7L) * 4455743L);
                    double threshold = 1.0 / this.minDistanceBetweenTowersArea;
                    if (random.nextDouble() > threshold) {
                        return;
                    }
                    int blockY = BattleTowersHandler.this.reflector.getSurfaceBlockHeight(this.worldGenHandler, world, blockX, blockZ);
                    if (blockY <= 49) {
                        return;
                    }
                    Object towerPosition = BattleTowersHandler.this.reflector.newTowerPosition(this.worldGenHandler, blockX, 0, blockZ, 0, false);
                    world.field_73012_v.setSeed(random.nextLong());
                    boolean spawned = BattleTowersHandler.this.reflector.attemptToSpawnTower(this.worldGenHandler, world, towerPosition, random, middlePos.func_177958_n(), blockY, middlePos.func_177952_p());
                    if (spawned) {
                        RLTweaker.logger.trace("BattleTower generation success: " + middlePos.func_177958_n() + " " + middlePos.func_177952_p());
                    } else {
                        RLTweaker.logger.trace("BattleTower generation failure: " + middlePos.func_177958_n() + " " + middlePos.func_177952_p());
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                this.generateWrapped(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                return;
            }
        }
    }

    public class GolemHurtByTarget
    extends EntityAIHurtByTarget {
        public GolemHurtByTarget(EntityCreature creature, boolean entityCallsForHelp, Class<?>[] excludedReinforcements) {
            super(creature, entityCallsForHelp, (Class[])excludedReinforcements);
            this.field_75297_f = false;
        }

        public double func_111175_f() {
            double ret = super.func_111175_f();
            ret = 64.0;
            return ret;
        }
    }

    public class BTWorldSaveEvent {
        private IEventListener handler;

        public BTWorldSaveEvent(IEventListener handler) {
            this.handler = handler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onWorldSave(WorldEvent.Save event) {
            if (ModConfig.server.battletowers.consistentTowerGeneration) {
                return;
            }
            this.handler.invoke((Event)event);
        }
    }

    public class BTWorldLoadEvent {
        private IEventListener handler;

        public BTWorldLoadEvent(IEventListener handler) {
            this.handler = handler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
            if (ModConfig.server.battletowers.consistentTowerGeneration) {
                return;
            }
            this.handler.invoke((Event)event);
            if (ModConfig.server.battletowers.dimensionBlacklistEnabled && !BattleTowersHandler.this.isDimensionWhitelisted(event.getWorld())) {
                boolean success = false;
                try {
                    success = BattleTowersHandler.this.reflector.setWorldDisableGenerationHook(event.getWorld(), 1000);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    // empty catch block
                }
                if (!success) {
                    RLTweaker.logger.error("Failed to prevent Battletowers from spawning in loaded dimension: " + event.getWorld().field_73011_w.getDimension());
                    ErrorUtil.logSilent("BT Dimension Blacklist Failure");
                }
            }
        }
    }
}

